/* <nagf08.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f08 Chapter
 *
 * Mark 5, 1997.
 * Mark 6 revised. IER-3038 (July 2000).
 */
#ifndef NAGF08
#define NAGF08

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  // Cheney change Complex to complex  2006-6-6 
  extern NAG_DLL_EXPIMP void NAG_CALL f08aec(Nag_OrderType order, Integer m, Integer n, double a[], 
  			Integer pda, double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08afc(Nag_OrderType order, Integer m, Integer n, Integer k, 
  			double a[], Integer pda, const double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08agc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_TransType trans, Integer m, Integer n, Integer k, const double a[], Integer pda, 
  			const double tau[], double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ahc(Nag_OrderType order, Integer m, Integer n, double a[], 
  			Integer pda, double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ajc(Nag_OrderType order, Integer m, Integer n, Integer k, 
  			double a[], Integer pda, const double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08akc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_TransType trans, Integer m, Integer n, Integer k, const double a[], Integer pda, 
  			const double tau[], double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08asc(Nag_OrderType order, Integer m, Integer n, complex a[], 
  			Integer pda, complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08atc(Nag_OrderType order, Integer m, Integer n, Integer k, 
  			complex a[], Integer pda, const complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08auc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_TransType trans, Integer m, Integer n, Integer k, const complex a[], Integer pda, 
  			const complex tau[], complex c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08avc(Nag_OrderType order, Integer m, Integer n, complex a[], 
  			Integer pda, complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08awc(Nag_OrderType order, Integer m, Integer n, Integer k, 
  			complex a[], Integer pda, const complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08axc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_TransType trans, Integer m, Integer n, Integer k, const complex a[], Integer pda,
  			const complex tau[], complex c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08bec(Nag_OrderType order, Integer m, Integer n, double a[], 
  			Integer pda, Integer jpvt[], double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08bsc(Nag_OrderType order, Integer m, Integer n, complex a[], 
  			Integer pda, Integer jpvt[], complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fcc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_UploType uplo, Integer n, double a[], Integer pda, double w[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fec(Nag_OrderType order, const Nag_UploType uplo, 
  			Integer n, double a[], Integer pda, double d[], double e[], double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ffc(Nag_OrderType order, const Nag_UploType uplo, 
  			Integer n, double a[], Integer pda, const double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fgc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_UploType uplo, const Nag_TransType trans, Integer m, Integer n, const double a[], 
  			Integer pda, const double tau[], double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fqc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_UploType uplo, Integer n, complex a[], Integer pda, double w[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fsc(Nag_OrderType order, const Nag_UploType uplo, 
  			Integer n, complex a[], Integer pda, double d[], double e[], complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ftc(Nag_OrderType order, const Nag_UploType uplo, 
  			Integer n, complex a[], Integer pda, const complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fuc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_UploType uplo, const Nag_TransType trans, Integer m, Integer n, const complex a[],
  			Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gcc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_UploType uplo, Integer n, double ap[], double w[], double z[], Integer pdz, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gec(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			double ap[], double d[], double e[], double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gfc(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			const double ap[], const double tau[], double q[], Integer pdq, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ggc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_UploType uplo, const Nag_TransType trans, Integer m, Integer n, double ap[], 
  			const double tau[], double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gqc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_UploType uplo, Integer n, complex ap[], double w[], complex z[], Integer pdz, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gsc(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			complex ap[], double d[], double e[], complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gtc(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			const complex ap[], const complex tau[], complex q[], Integer pdq, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08guc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_UploType uplo, const Nag_TransType trans, Integer m, Integer n, complex ap[], 
  			const complex tau[], complex c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hcc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, double w[], 
  			double z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hec(Nag_OrderType order, const Nag_VectType vect, 
  			const Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, double d[], 
  			double e[], double q[], Integer pdq, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hqc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, double w[], 
  			complex z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hsc(Nag_OrderType order, const Nag_VectType vect, 
  			const Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, double d[], 
  			double e[], complex q[], Integer pdq, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jcc(Nag_OrderType order, const Nag_JobType job, Integer n, 
  			double d[], double e[], double z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jec(Nag_OrderType order, const Nag_ComputeZType compz, 
  			Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jfc(Integer n, double d[], double e[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jgc(Nag_OrderType order, const Nag_ComputeZType compz, 
  			Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jjc(const Nag_RangeType range, const Nag_EigValRankType rank, 
  			Integer n, double vl, double vu, Integer il, Integer iu, double abstol, const double d[], 
  			const double e[], Integer *m, Integer *nsplit, double w[], Integer iblock[], 
  			Integer isplit[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jkc(Nag_OrderType order, Integer n, const double d[], 
  			const double e[], Integer m, const double w[], const Integer iblock[], 
  			const Integer isplit[], double z[], Integer pdz, Integer ifailv[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jsc(Nag_OrderType order, const Nag_ComputeZType compz, 
  			Integer n, double d[], double e[], complex z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08juc(Nag_OrderType order, const Nag_ComputeZType compz, 
  			Integer n, double d[], double e[], complex z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jxc(Nag_OrderType order, Integer n, const double d[], 
  			const double e[], Integer m, const double w[], const Integer iblock[], 
  			const Integer isplit[], complex z[], Integer pdz, Integer ifailv[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kec(Nag_OrderType order, Integer m, Integer n, 
  			double a[], Integer pda, double d[], double e[], double tauq[], double taup[], 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kfc(Nag_OrderType order, const Nag_VectType vect, 
  			Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kgc(Nag_OrderType order, const Nag_VectType vect, 
  			const Nag_SideType side, const Nag_TransType trans, Integer m, Integer n, Integer k, 
  			const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ksc(Nag_OrderType order, Integer m, Integer n, 
  			complex a[], Integer pda, double d[], double e[], complex tauq[], complex taup[], 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ktc(Nag_OrderType order, const Nag_VectType vect, 
  			Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kuc(Nag_OrderType order, const Nag_VectType vect,
  			const Nag_SideType side, const Nag_TransType trans, Integer m, Integer n, Integer k, 
  			const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08lec(Nag_OrderType order, const Nag_VectType vect, 
  			Integer m, Integer n, Integer ncc, Integer kl, Integer ku, double ab[], Integer pdab, 
  			double d[], double e[], double q[], Integer pdq, double pt[], Integer pdpt, double c[], 
  			Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08lsc(Nag_OrderType order, const Nag_VectType vect, 
  			Integer m, Integer n, Integer ncc, Integer kl, Integer ku, complex ab[], Integer pdab, 
  			double d[], double e[], complex q[], Integer pdq, complex pt[], Integer pdpt, complex c[], 
  			Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08mec(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			Integer ncvt, Integer nru, Integer ncc, double d[], double e[], double vt[], Integer pdvt, 
  			double u[], Integer pdu, double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08msc(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			Integer ncvt, Integer nru, Integer ncc, double d[], double e[], complex vt[], Integer pdvt,
  			complex u[], Integer pdu, complex c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nec(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, 
  			double a[], Integer pda, double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nfc(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, 
  			double a[], Integer pda, const double tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ngc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_TransType trans, Integer m, Integer n, Integer ilo, Integer ihi, const double a[],
  			Integer pda, const double tau[], double c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nhc(Nag_OrderType order, const Nag_JobType job, Integer n, 
  			double a[], Integer pda, Integer *ilo, Integer *ihi, double scale[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08njc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double scale[], 
  			Integer m, double v[], Integer pdv, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nsc(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, 
  			complex a[], Integer pda, complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ntc(Nag_OrderType order, Integer n, Integer ilo, Integer ihi,
  			complex a[], Integer pda, const complex tau[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nuc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_TransType trans, Integer m, Integer n, Integer ilo, Integer ihi, const complex a[],
  			Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nvc(Nag_OrderType order, const Nag_JobType job, Integer n, 
  			complex a[], Integer pda, Integer *ilo, Integer *ihi, double scale[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nwc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double scale[], 
  			Integer m, complex v[], Integer pdv, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pec(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, double h[], Integer pdh,
  			double wr[], double wi[], double z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pkc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_EigValsSourceType eig_source, const Nag_InitVeenumtype initv, Boolean select[], 
  			Integer n, const double h[], Integer pdh, double wr[], const double wi[], double vl[], 
  			Integer pdvl, double vr[], Integer pdvr, Integer mm, Integer *m, Integer ifaill[], 
  			Integer ifailr[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08psc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, complex h[], 
  			Integer pdh, complex w[], complex z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pxc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_EigValsSourceType eig_source, const Nag_InitVeenumtype initv, 
  			const Boolean select[], Integer n, const complex h[], Integer pdh, complex w[], 
  			complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer mm, Integer *m, 
  			Integer ifaill[], Integer ifailr[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qfc(Nag_OrderType order, const Nag_ComputeQType compq, 
  			Integer n, double t[], Integer pdt, double q[], Integer pdq, Integer *ifst, Integer *ilst,
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qgc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_ComputeQType compq, const Boolean select[], Integer n, double t[], Integer pdt, 
  			double q[], Integer pdq, double wr[], double wi[], Integer *m, double *s, double *sep, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qhc(Nag_OrderType order, const Nag_TransType trana, 
  			const Nag_TransType tranb, Nag_SignType sign, Integer m, Integer n, const double a[], 
  			Integer pda, const double b[], Integer pdb, double c[], Integer pdc, double *scale, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qkc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_HowManyType how_many, Boolean select[], Integer n, const double t[], 
  			Integer pdt, double vl[], Integer pdvl, double vr[], Integer pdvr, Integer mm, Integer *m, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qlc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_HowManyType how_many, const Boolean select[], Integer n, const double t[], 
  			Integer pdt, const double vl[], Integer pdvl, const double vr[], Integer pdvr, double s[], 
  			double sep[], Integer mm, Integer *m, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qtc(Nag_OrderType order, const Nag_ComputeQType compq, 
  			Integer n, complex t[], Integer pdt, complex q[], Integer pdq, Integer ifst, Integer ilst, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08quc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_ComputeQType compq, const Boolean select[], Integer n, complex t[], Integer pdt,
  			complex q[], Integer pdq, complex w[], Integer *m, double *s, double *sep, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qvc(Nag_OrderType order, const Nag_TransType trana, 
  			const Nag_TransType tranb, Nag_SignType sign, Integer m, Integer n, const complex a[], 
  			Integer pda, const complex b[], Integer pdb, complex c[], Integer pdc, double *scal, 
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qxc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_HowManyType how_many, const Boolean select[], Integer n, complex t[], 
  			Integer pdt, complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer mm, Integer *m,
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qyc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_HowManyType how_many, const Boolean select[], Integer n, const complex t[], 
  			Integer pdt, const complex vl[], Integer pdvl, const complex vr[], Integer pdvr, 
  			double s[], double sep[], Integer mm, Integer *m, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08sec(Nag_OrderType order, Nag_ComputeType comp_type, 
  			const Nag_UploType uplo, Integer n, double a[], Integer pda, const double b[], Integer pdb,
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ssc(Nag_OrderType order, Nag_ComputeType comp_type, 
  			const Nag_UploType uplo, Integer n, complex a[], Integer pda, const complex b[], 
  			Integer pdb, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08tec(Nag_OrderType order, Nag_ComputeType comp_type, 
  			const Nag_UploType uplo, Integer n, double ap[], const double bp[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08tsc(Nag_OrderType order, Nag_ComputeType comp_type, 
  			const Nag_UploType uplo, Integer n, complex ap[], const complex bp[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08uec(Nag_OrderType order, const Nag_VectType vect, 
  			const Nag_UploType uplo, Integer n, Integer ka, Integer kb, double ab[], Integer pdab, 
  			const double bb[], Integer pdbb, double x[], Integer pdx, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ufc(Nag_OrderType order, const Nag_UploType uplo, 
  			Integer n, Integer kb, double bb[], Integer pdbb, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08usc(Nag_OrderType order, const Nag_VectType vect, 
  			const Nag_UploType uplo, Integer n, Integer ka, Integer kb, complex ab[], Integer pdab, 
  			const complex bb[], Integer pdbb, complex x[], Integer pdx, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08utc(Nag_OrderType order, const Nag_UploType uplo, Integer n, 
  			Integer kb, complex bb[], Integer pdbb, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wec(Nag_OrderType order, const Nag_ComputeQType compq, 
  			const Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, double a[], Integer pda,
  			double b[], Integer pdb, double q[], Integer pdq, double z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08whc(Nag_OrderType order, const Nag_JobType job, 
  			Integer n, double a[], Integer pda, double b[], Integer pdb, Integer *ilo, Integer *ihi, 
  			double lscale[], double rscale[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wjc(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double lscale[], 
  			const double rscale[], Integer m, double v[], Integer pdv, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wsc(Nag_OrderType order, const Nag_ComputeQType compq, 
  			const Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, complex a[], 
  			Integer pda, complex b[], Integer pdb, complex q[], Integer pdq, complex z[], Integer pdz,
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wvc(Nag_OrderType order, const Nag_JobType job, Integer n,
  			complex a[], Integer pda, complex b[], Integer pdb, Integer *ilo, Integer *ihi, 
  			double lscale[], double rscale[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wwc(Nag_OrderType order, const Nag_JobType job,
  			const Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double lscale[],
  			const double rscale[], Integer m, complex v[], Integer pdv, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08xec(Nag_OrderType order, const Nag_JobType job, 
  			const Nag_ComputeQType compq, const Nag_ComputeZType compz, Integer n, Integer ilo, 
  			Integer ihi, double a[], Integer pda, double b[], Integer pdb, double alphar[], 
  			double alphai[], double beta[], double q[], Integer pdq, double z[], Integer pdz,
  			NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08xsc(Nag_OrderType order, const Nag_JobType job,
  			const Nag_ComputeQType compq, const Nag_ComputeZType compz, Integer n, Integer ilo,
  			Integer ihi, complex a[], Integer pda, complex b[], Integer pdb, complex alpha[], 
  			complex beta[], complex q[], Integer pdq, complex z[], Integer pdz, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ykc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_HowManyType how_many, const Boolean select[], Integer n, const double a[], 
  			Integer pda, const double b[], Integer pdb, double vl[], Integer pdvl, double vr[], 
  			Integer pdvr, Integer mm, Integer *m, NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL f08yxc(Nag_OrderType order, const Nag_SideType side, 
  			const Nag_HowManyType how_many, const Boolean select[], Integer n, const complex a[], 
  			Integer pda, const complex b[], Integer pdb, complex vl[], Integer pdvl, complex vr[],
  			Integer pdvr, Integer mm, Integer *m, NagError *fail); 

  extern void f08aef(Integer m, Integer n, double a[], Integer lda,
                     double tau[], double work[], Integer lwork,
                     Integer *info);
  extern void f08aev_f(Integer n, double *alpha, double x[], Integer incx,
                       double *tau);
  extern void f08aev(Integer n,  double *alpha, double x[],  Integer incx,
                     double *tau);
  extern void f08aew_f(const char *side, Integer m, Integer n, const double v[],
                       Integer incv, double tau, double c[], Integer ldc,
                       double work[], Integer side_len);
  extern void f08aew(OperationSide Side,  Integer m, Integer n,  double v[],
                     Integer incv,  double tau, double c[],  Integer tdc,
                     double work[]);
  extern void f08aex_f(const char *direct, const char *storev, Integer n, Integer k,
                       double v[], Integer ldv, const double tau[], double t[],
                       Integer ldt, Integer direct_len, Integer storev_len);
  extern void f08aex(const char *direct, const char *storev, Integer n, Integer k,
                     double v[], Integer ldv, double tau[],
                     double t[], Integer ldt);
  extern void f08aey_f(const char *side, const char *trans, const char *direct, const char *storev,
                       Integer m, Integer n, Integer k, const double v[],
                       Integer ldv, const double t[], Integer ldt, double c[],
                       Integer ldc, double work[], Integer ldwork, Integer side_len,
                       Integer trans_len, Integer direct_len, Integer storev_len);
  extern void f08aey(const char *side, const char *trans, const char *direct, const char *storev, Integer m,
                     Integer n, Integer k, double v[], Integer ldv,
                     double t[], Integer ldt, double c[], Integer ldc,
                     double work[], Integer ldwork);
  extern void f08aez(Integer m, Integer n, double a[], Integer lda,
                     double tau[], double work[], Integer *info);
  extern void f08aff_f(Integer m, Integer n, Integer k, double a[],
                       Integer lda, const double tau[], double work[], Integer lwork,
                       Integer *info);
  extern void f08aff(Integer m, Integer n, Integer k, double a[],
                     Integer lda, double tau[], double work[],
                     Integer lwork, Integer *info);
  extern void f08afz_f(Integer m, Integer n, Integer k, double a[],
                       Integer lda, const double tau[], double work[], Integer *info);
  extern void f08afz(Integer m, Integer n, Integer k, double a[],
                     Integer lda, double tau[], double work[],
                     Integer *info);
  extern void f08agf(const char *side, const char *trans, Integer m, Integer n, Integer k,
                     double a[], Integer lda, double tau[],
                     double c[], Integer ldc, double work[],
                     Integer lwork, Integer *info);
  extern void f08agz(const char *side, const char *trans, Integer m, Integer n, Integer k,
                     double a[], Integer lda, double tau[],
                     double c[], Integer ldc, double work[],
                     Integer *info);
  extern void f08asf(Integer m, Integer n, complex a[], Integer lda,
                     complex tau[], complex work[], Integer lwork,
                     Integer *info);
  extern double f08asu(double x, double y, double z);
  extern void f08asv(Integer n, complex *alpha, complex x[],
                     Integer incx, complex *tau);
  extern void f08asw(const char *side, Integer m, Integer n, complex v[],
                     Integer incv, complex *tau, complex c[],
                     Integer ldc, complex work[]);
  extern void f08asx(const char *direct, const char *storev, Integer n, Integer k,
                     complex v[], Integer ldv, complex tau[],
                     complex t[], Integer ldt);
  extern void f08asy(const char *side, const char *trans, const char *direct, const char *storev,
                     Integer m, Integer n, Integer k, complex v[],
                     Integer ldv, complex t[], Integer ldt,
                     complex c[], Integer ldc, complex work[],
                     Integer ldwork);
  extern void f08asz(Integer m, Integer n, complex a[], Integer lda,
                     complex tau[], complex work[], Integer *info);
  extern void f08atf(Integer m, Integer n, Integer k, complex a[],
                     Integer lda, complex tau[], complex work[],
                     Integer lwork, Integer *info);
  extern void f08atz(Integer m, Integer n, Integer k, complex a[],
                     Integer lda, complex tau[], complex work[],
                     Integer *info);
  extern void f08auf(const char *side, const char *trans, Integer m, Integer n, Integer k,
                     complex a[], Integer lda, complex tau[],
                     complex c[], Integer ldc, complex work[],
                     Integer lwork, Integer *info);
  extern void f08auz(const char *side, const char *trans, Integer m, Integer n, Integer k,
                     complex a[], Integer tda, complex tau[],
                     complex c[], Integer tdc, complex work[],
                     Integer *info);
  extern void f08cfy_f(Integer m, Integer n, Integer k, double a[],
                       Integer lda, const double tau[], double work[], Integer lwork,
                       Integer *info);
  extern void f08cfy(Integer m, Integer n, Integer k, double a[],
                     Integer lda, double tau[], double work[],
                     Integer lwork, Integer *info);
  extern void f08cfz_f(Integer m, Integer n, Integer k, double a[],
                       Integer lda, const double tau[], double work[], Integer *info);
  extern void f08cfz(Integer m, Integer n, Integer k, double a[],
                     Integer lda, double tau[], double work[],
                     Integer *info);
  extern void f08fef_f(const char *uplo, Integer n, double a[], Integer lda,
                       double d[], double e[], double tau[], double work[],
                       Integer lwork, Integer *info, Integer uplo_len);
  extern void f08fef(const char *uplo, Integer n, double a[], Integer lda,
                     double d[], double e[], double tau[],
                     double work[], Integer lwork, Integer *info);
  extern void f08fey_f(const char *uplo, Integer n, Integer nb, double a[],
                       Integer lda, double e[], double tau[], double w[],
                       Integer ldw, Integer uplo_len);
  extern void f08fey(const char *uplo, Integer n, Integer nb, double a[],
                     Integer lda, double e[], double tau[], double w[],
                     Integer ldw);
  extern void f08fez_f(const char *uplo, Integer n, double a[], Integer lda,
                       double d[], double e[], double tau[], Integer *info,
                       Integer uplo_len);
  extern void f08fez(const char *uplo, Integer n, double a[], Integer lda,
                     double d[], double e[], double tau[],
                     Integer *info);
  extern void f08fff_f(const char *uplo, Integer n, double a[], Integer lda,
                       const double tau[], double work[], Integer lwork, Integer *info,
                       Integer uplo_len);
  extern void f08fff(const char *uplo, Integer n, double a[], Integer lda,
                     double tau[], double work[], Integer lwork,
                     Integer *info);
  extern void f08gef(MatrixTriangle UpperLower,  Integer n,  double ap[], double d[],
                     double e[], double tau[],  Integer *info);
  extern void f08ggf(OperationSide Side, MatrixTriangle Uplo, MatrixTranspose Trans,  Integer m, Integer n,
                     double ap[], double tau[], double c[],  Integer tdc,
                     double work[],  Integer *info);
  extern void f08hew_f(double f, double g, double *cs, double *sn,
                       double *r);
  extern void f08hew(double f, double g, double *cs, double *sn,
                     double *r);
  extern void f08jef_f(const char *compz, Integer n, double d[], double e[],
                       double z[], Integer ldz, double work[], Integer *info,
                       Integer compz_len);
  extern void f08jef(const char *compz, Integer n, double d[], double e[],
                     double z[], Integer ldz, double work[],
                     Integer *info);
  extern void f08jex_f(double a, double b, double c, double *rt1,
                       double *rt2);
  extern void f08jex(double a, double b, double c, double *rt1,
                     double *rt2);
  extern void f08jff_f(Integer n, double d[], double e[], Integer *info);
  extern void f08jff(Integer n,  double d[], double e[],  Integer *info);
  extern void f08jjf(const char *range, const char *order,  Integer n,  double vl,
                     double vu,  Integer il, Integer iu,  double abstol,
                     double d[], double e[],  Integer *m, Integer *nsplit,
                     double w[],  Integer iblock[], Integer isplit[],
                     double work[],  Integer iwork[], Integer *info);
  extern void f08jjz(Integer ijob, Integer nitmax, Integer n, Integer mmax,
                     Integer minp, Integer nbmin,  double abstol,
                     double reltol, double pivmin, double d[],
                     double e[], double e2[],  Integer nval[],
                     double ab[], double c[],  Integer *mout, Integer nab[],
                     double work[],  Integer iwork[], Integer *info);
  extern void f08jkf(Integer n,  double d[], double e[],  Integer m,
                     double w[],  Integer iblock[], Integer isplit[],
                     double z[],  Integer tdz,  double work[],
                     Integer iwork[], Integer ifail[], Integer *info);
  extern void f08nef(Integer n, Integer ilo, Integer ihi, double a[],
                     Integer lda, double tau[], double work[],
                     Integer lwork, Integer *info);
  extern void f08ney(Integer n, Integer k, Integer nb, double a[],
                     Integer lda, double tau[], double t[], Integer ldt,
                     double y[], Integer ldy);
  extern void f08nez(Integer n, Integer ilo, Integer ihi, double a[],
                     Integer lda, double tau[], double work[],
                     Integer *info);
  extern void f08ngf(const char *side, const char *trans, Integer m, Integer n, Integer ilo,
                     Integer ihi, double a[], Integer lda, double tau[],
                     double c[], Integer ldc, double work[],
                     Integer lwork, Integer *info);
  extern void f08nhf(const char *job, Integer n, double a[], Integer lda,
                     Integer *ilo, Integer *ihi, double scale[], Integer *info);
  extern void f08nhf_f (const char *job, Integer n, double a[], Integer lda,
			Integer * ilo, Integer * ihi, double scale[],
			Integer * info,	Integer job_len);

  extern void f08njf(const char *job, const char *side, Integer n, Integer ilo, Integer ihi,
                     double scale[], Integer m, double v[], Integer ldv,
                     Integer *info);
  extern void f08nsf(Integer n, Integer ilo, Integer ihi, complex a[],
                     Integer lda, complex tau[], complex work[],
                     Integer lwork, Integer *info);
  extern void f08nsy(Integer n, Integer k, Integer nb, complex a[],
                     Integer lda, complex tau[], complex t[],
                     Integer ldt, complex y[], Integer ldy);
  extern void f08nsz(Integer n, Integer ilo, Integer ihi, complex a[],
                     Integer lda, complex tau[], complex work[],
                     Integer *info);
  extern void f08nuf(const char *side, const char *trans, Integer m, Integer n, Integer ilo,
                     Integer ihi, complex a[], Integer lda,
                     complex tau[], complex c[], Integer ldc,
                     complex work[], Integer lwork, Integer *info);
  extern void f08nvf(const char *job, Integer n, complex a[], Integer lda,
                     Integer *ilo, Integer *ihi, double scale[], Integer *info);
  extern void f08nwf(const char *job, const char *side, Integer n, Integer ilo, Integer ihi,
                     double scale[], Integer m, complex v[],
                     Integer ldv, Integer *info);
  extern void f08pef(const char *job, const char *compz, Integer n, Integer ilo, Integer ihi,
                     double h[], Integer ldh, double wr[], double wi[],
                     double z[], Integer ldz, double work[],
                     Integer lwork, Integer *info);
  extern void f08pef_f(const char *job, const char *compz, Integer n, Integer ilo,
		     Integer ihi, double h[], Integer ldh, double wr[],
		     double wi[], double z[], Integer ldz, double work[],
		     Integer lwork, Integer *info, Integer job_len, Integer compz_len);
  extern void f08pew(const char *side, Integer m, Integer n, double v[],
                     double tau, double c[], Integer ldc,
                     double work[]);
  extern void f08pew_f(const char *side, Integer m, Integer n, const double v[],
		       double tau, double c[], Integer ldc, double work[],
		       Integer side_len);
  extern void f08pey(double *a, double *b, double *c, double *d,
                     double *rt1r, double *rt1i, double *rt2r,
                     double *rt2i, double *cs, double *sn);
  extern void f08pey_f(double *a, double *b, double *c, double *d,
		       double *rt1r, double *rt1i, double *rt2r, double *rt2i,
		       double *cs, double *sn);
  extern void f08pez(Boolean wantt, Boolean wantz, Integer n, Integer ilo,
                     Integer ihi, double h[], Integer ldh, double wr[],
                     double wi[], Integer iloz, Integer ihiz, double z[],
                     Integer ldz, Integer *info);
  extern void f08pez_f(Boolean wantt, Boolean wantz, Integer n, Integer ilo,
		       Integer ihi, double h[], Integer ldh, double wr[],
		       double wi[], Integer iloz, Integer ihiz, double z[],
		       Integer ldz, Integer *info);
  extern void f08pkf(const char *job, const char *eigsrc, const char *initv, Boolean select[],
                     Integer n, double h[], Integer ldh, double wr[],
                     double wi[], double vl[], Integer ldvl,
                     double vr[], Integer ldvr, Integer mm, Integer *m,
                     double work[], Integer ifaill[], Integer ifailr[],
                     Integer *info);
  extern void f08pkz(Boolean rightv, Boolean noinit, Integer n, double h[],
                     Integer ldh, double wr, double wi, double vr[],
                     double vi[], double b[], Integer ldb,
                     double work[], double eps3, double smlnum,
                     double bignum, Integer *info);
  extern void f08psf(const char *job, const char *compz, Integer n, Integer ilo,
                     Integer ihi, complex h[], Integer ldh,
                     complex w[], complex z[], Integer ldz,
                     complex work[], Integer lwork, Integer *info);
  extern void f08psw(const char *side, Integer m, Integer n, complex v[],
                     complex *tau, complex c[], Integer ldc,
                     complex work[]);
  extern void f08psz(Boolean wantt, Boolean wantz, Integer n, Integer ilo,
                     Integer ihi, complex h[], Integer ldh,
                     complex w[], Integer iloz, Integer ihiz,
                     complex z[], Integer ldz, Integer *info);
  extern void f08pxf(const char *job, const char *eigsrc, const char *initv, Boolean select[],
                     Integer n, complex h[], Integer ldh,
                     complex w[], complex vl[], Integer ldvl,
                     complex vr[], Integer ldvr, Integer mm, Integer *m,
                     complex work[], double rwork[], Integer ifaill[],
                     Integer ifailr[], Integer *info);
  extern void f08pxz(Boolean rightv, Boolean noinit, Integer n,
                     complex h[], Integer ldh, complex *w,
                     complex v[], complex b[], Integer ldb,
                     double rwork[], double eps3, double smlnum,
                     Integer *info);
  extern void f08qff_f(const char *compq, Integer n, double t[], Integer ldt,
		       double q[], Integer ldq, Integer *ifst, Integer *ilst,
		       double work[], Integer *info, Integer compq_len);
  extern void f08qfz_f(Boolean wantq, Integer n, double t[], Integer ldt,
		       double q[], Integer ldq, Integer j1, Integer n1,
		       Integer n2, double work[], Integer *info);
  extern void f08qhx_f(Boolean ltrans, Integer na, Integer nw, double smin,
		       double ca, const double a[], Integer lda, double d1,
		       double d2, const double b[], Integer ldb, double wr,
		       double wi, double x[], Integer ldx, double *scale,
		       double *xnorm, Integer *info);
  extern void f08qhy_f(Boolean ltranl, Boolean ltranr, Integer isgn,
		       Integer n1, Integer n2, const double tl[],
		       Integer ldtl, const double tr[], Integer ldtr,
		       const double b[], Integer ldb, double *scale,
		       double x[], Integer ldx, double *xnorm, Integer *info);
  extern void f08qkf_f(const char *job, const char *howmny, Boolean select[], Integer n,
		       const double t[], Integer ldt, double vl[], Integer ldvl,
		       double vr[], Integer ldvr, Integer mm, Integer *m,
		       double work[], Integer *info, Integer job_len, Integer howmny_len);
  extern void  f08qlf_c (const char *job, const char *howmny, const Boolean select[], Integer n,
			 const double t[], Integer ldt, const double vl[], Integer ldvl,
			 const double vr[], Integer ldvr, double s[], double sep[],
			 Integer mm, Integer *m, double work[], Integer ldwork,
			 Integer iwork[], Integer * info, Integer job_len, Integer howmny_len);

  extern void f08qlf_f(const char *job, const char *howmny, const Boolean select[], Integer n,
		       const double t[], Integer ldt, const double vl[], Integer ldvl,
		       const double vr[], Integer ldvr, double s[], double sep[],
		       Integer mm, Integer *m, double work[], Integer ldwork,
		       Integer iwork[], Integer *info, Integer job_len, Integer howmny_len);
  extern void f08qlz_f(Boolean ltran, Boolean lreal, Integer n, const double t[],
		       Integer ldt, const double b[], double w, double *scale,
		       double x[], double work[], Integer *info);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF08 */
